/*
 * Decompiled with CFR 0.152.
 */
package uminho.di.greenlab.trepnlibrary;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Scanner;

public class TrepnLib {
    static Context context;
    static int globalState;
    static int qtdTraces;
    static int qtdMeasures;
    static final String trepTag = "[TrepnLib]";
    static final String csvFilename = "GreendroidResultTrace";
    static final String dbFilename = "";
    static final int coolDownTimeMilis = 3000;
    static final int warmUpTimeMilis = 3000;

    public static Context initContext() {
        Context ctx = null;
        if (context == null) {
            try {
                Application app = TrepnLib.getApplicationUsingReflection();
                context = app.getApplicationContext();
                return app.getApplicationContext();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ctx;
    }

    public static void loadPreferences(Context ctx, String preferencesFilename) {
        Intent loadPreferences = new Intent("com.quicinc.trepn.load_preferences");
        loadPreferences.putExtra("com.quicinc.trepn.load_preferences_file", preferencesFilename);
        ctx.sendBroadcast(loadPreferences);
    }

    public static void startProfiling(Context ctx) {
        block8: {
            try {
                if (TrepnLib.getFlag() < 0) break block8;
                context = ctx;
                Intent trepnProfiler = new Intent();
                trepnProfiler.setClassName("com.quicinc.trepn", "com.quicinc.trepn.TrepnService");
                ctx.startService(trepnProfiler);
                File sdCard = Environment.getExternalStorageDirectory();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                TrepnLib.loadPreferences(ctx, sdCard.getAbsolutePath() + "/trepn/saved_preferences/trepnPreferences/All.pref");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Intent startWithDb = new Intent("com.quicinc.trepn.start_profiling");
                startWithDb.putExtra("com.quicinc.trepn.database_file", "greendroid2");
                ctx.sendBroadcast(startWithDb);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Exception e) {
                context = null;
            }
        }
    }

    public static void startProfilingTest(Context ctx) {
        block25: {
            try {
                int flg;
                File sdCard = Environment.getExternalStorageDirectory();
                File ft = new File(sdCard.getAbsolutePath() + "/trepn/TracedTests/TracedTests.txt");
                if (!ft.exists()) {
                    try {
                        ft.createNewFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if ((flg = TrepnLib.getFlag()) == 0) {
                    Intent trepnProfiler = new Intent();
                    trepnProfiler.setClassName("com.quicinc.trepn", "com.quicinc.trepn.TrepnService");
                    ctx.startService(trepnProfiler);
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    TrepnLib.loadPreferences(ctx, sdCard.getAbsolutePath() + "/trepn/saved_preferences/trepnPreferences/All.pref");
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Intent startWithDb = new Intent("com.quicinc.trepn.start_profiling");
                    startWithDb.putExtra("com.quicinc.trepn.database_file", "greendroid2Trace");
                    ctx.sendBroadcast(startWithDb);
                    try {
                        Thread.sleep(9000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    File directory2 = new File(sdCard.getAbsolutePath() + "/trepn/Traces");
                    File directory3 = new File(sdCard.getAbsolutePath() + "/trepn/Measures");
                    File file = new File(sdCard.getAbsolutePath() + "/trepn/TracedMethods.txt");
                    if (!file.exists()) {
                        try {
                            file.createNewFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    TrepnLib.updateState(ctx, 1, "started");
                    break block25;
                }
                if (flg == 1) {
                    File directory3 = new File(sdCard.getAbsolutePath() + "/trepn/Measures");
                    qtdMeasures = directory3.list().length;
                    Intent trepnProfiler = new Intent();
                    trepnProfiler.setClassName("com.quicinc.trepn", "com.quicinc.trepn.TrepnService");
                    ctx.startService(trepnProfiler);
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException directory2) {
                        // empty catch block
                    }
                    TrepnLib.loadPreferences(ctx, sdCard.getAbsolutePath() + "/trepn/saved_preferences/trepnPreferences/All.pref");
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException directory2) {
                        // empty catch block
                    }
                    Intent startWithDb = new Intent("com.quicinc.trepn.start_profiling");
                    startWithDb.putExtra("com.quicinc.trepn.database_file", "greendroid2Trace");
                    ctx.sendBroadcast(startWithDb);
                    try {
                        Thread.sleep(9000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    TrepnLib.updateState(ctx, 1, "started");
                    break block25;
                }
                File directory2 = new File(sdCard.getAbsolutePath() + "/trepn/Traces");
                File file = new File(sdCard.getAbsolutePath() + "/trepn/TracedMethods.txt");
                if (!file.exists()) {
                    try {
                        boolean bl = file.createNewFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                qtdTraces = directory2.list().length;
            }
            catch (Exception e) {
                context = null;
            }
        }
    }

    public static void stopProfilingTest(Context ctx) {
        try {
            int flg = TrepnLib.getFlag();
            if (flg == 0) {
                TrepnLib.updateState(ctx, 0, "stopped");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Intent stopProfiling = new Intent("com.quicinc.trepn.stop_profiling");
                ctx.sendBroadcast(stopProfiling);
                Intent intent = new Intent("com.quicinc.trepn.export_to_csv");
                File sdCard2 = Environment.getExternalStorageDirectory();
                File dir = new File(sdCard2.getAbsolutePath() + "/trepn/Traces");
                intent.putExtra("com.quicinc.trepn.export_db_input_file", "greendroid2Trace");
                File directory3 = new File(sdCard2.getAbsolutePath() + "/trepn/Measures");
                int x = directory3.list().length;
                intent.putExtra("com.quicinc.trepn.export_csv_output_file", csvFilename + x);
                ctx.sendBroadcast(intent);
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                File f1 = new File(sdCard2.getAbsolutePath() + "/trepn/TracedMethods.txt");
                if (!f1.exists()) {
                    try {
                        f1.createNewFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                File f2 = new File(sdCard2.getAbsolutePath() + "/trepn/Traces/TracedMethods" + dir.list().length + ".txt");
                File f42 = new File(sdCard2.getAbsolutePath() + "/trepn/Measures/GreendroidResultTrace" + x + ".csv");
                File f3 = new File(sdCard2.getAbsolutePath() + "/trepn/GreendroidResultTrace" + x + ".csv");
                try {
                    TrepnLib.copyFile(f1, f2);
                    TrepnLib.copyFile(f3, f42);
                }
                catch (IOException e) {
                    try {
                        f1.createNewFile();
                        TrepnLib.copyFile(f1, f2);
                        TrepnLib.copyFile(f3, f42);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                f1.delete();
                f3.delete();
                if (directory3.list().length > 0 && directory3.list().length - 1 != qtdMeasures) {
                    File f = new File(sdCard2.getAbsolutePath() + "/trepn/Measures/GreendroidResultTrace" + directory3.list().length + ".csv");
                    try {
                        f.createNewFile();
                    }
                    catch (IOException iOException) {}
                }
            } else if (flg == 1) {
                File sdCard = Environment.getExternalStorageDirectory();
                File directory3 = new File(sdCard.getAbsolutePath() + "/trepn/Measures");
                TrepnLib.updateState(ctx, 0, "stopped");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException sdCard2) {
                    // empty catch block
                }
                Intent stopProfiling = new Intent("com.quicinc.trepn.stop_profiling");
                ctx.sendBroadcast(stopProfiling);
                Intent intent = new Intent("com.quicinc.trepn.export_to_csv");
                File dir = new File(sdCard.getAbsolutePath() + "/trepn/Traces");
                intent.putExtra("com.quicinc.trepn.export_db_input_file", "greendroid2Trace");
                int x = directory3.list().length;
                intent.putExtra("com.quicinc.trepn.export_csv_output_file", csvFilename + x);
                ctx.sendBroadcast(intent);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException f1) {
                    // empty catch block
                }
                File f4 = new File(sdCard.getAbsolutePath() + "/trepn/Measures/GreendroidResultTrace" + x + ".csv");
                File f3 = new File(sdCard.getAbsolutePath() + "/trepn/GreendroidResultTrace" + x + ".csv");
                try {
                    TrepnLib.copyFile(f3, f4);
                }
                catch (IOException f42) {
                    // empty catch block
                }
                f3.delete();
                if (directory3.list().length - 1 != qtdMeasures) {
                    File f = new File(sdCard.getAbsolutePath() + "/trepn/Measures/GreendroidResultTrace" + directory3.list().length + ".csv");
                    try {
                        f.createNewFile();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                File sdCard = Environment.getExternalStorageDirectory();
                File f1 = new File(sdCard.getAbsolutePath() + "/trepn/TracedMethods.txt");
                File dir = new File(sdCard.getAbsolutePath() + "/trepn/Traces");
                File f2 = new File(sdCard.getAbsolutePath() + "/trepn/Traces/TracedMethods" + dir.list().length + ".txt");
                try {
                    TrepnLib.copyFile(f1, f2);
                }
                catch (IOException e) {
                    try {
                        f1.createNewFile();
                        TrepnLib.copyFile(f1, f2);
                    }
                    catch (IOException x) {
                        // empty catch block
                    }
                }
                f1.delete();
                File directory2 = new File(sdCard.getAbsolutePath() + "/trepn/Traces");
                if (directory2.list().length > 0 && directory2.list().length - 1 != qtdTraces) {
                    File f = new File(sdCard.getAbsolutePath() + "/trepn/Traces/TracedMethods" + directory2.list().length + ".txt");
                    try {
                        f.createNewFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            context = null;
        }
        catch (Exception e) {
            context = null;
        }
    }

    private static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    TrepnLib.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
    }

    public static void stopProfiling(Context ctx) {
        try {
            if (TrepnLib.getFlag() >= 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Intent stateUpdate = new Intent("com.quicinc.Trepn.UpdateAppState");
                stateUpdate.putExtra("com.quicinc.Trepn.UpdateAppState.Value", String.valueOf(-1));
                stateUpdate.putExtra("com.quicinc.Trepn.UpdateAppState.Value.Desc", dbFilename);
                ctx.sendBroadcast(stateUpdate);
                Intent stopProfiling = new Intent("com.quicinc.trepn.stop_profiling");
                ctx.sendBroadcast(stopProfiling);
                Intent intent = new Intent("com.quicinc.trepn.export_to_csv");
                intent.putExtra("com.quicinc.trepn.export_db_input_file", "greendroid2");
                File sdCard = Environment.getExternalStorageDirectory();
                File directory = new File(sdCard.getAbsolutePath() + "/trepn");
                intent.putExtra("com.quicinc.trepn.export_csv_output_file", "GrendroidResult" + directory.list().length);
                ctx.sendBroadcast(intent);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            context = null;
        }
        catch (Exception e) {
            context = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File source, File dest) throws IOException {
        FileChannel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        try {
            sourceChannel = new FileInputStream(source).getChannel();
            destChannel = new FileOutputStream(dest).getChannel();
            ((FileChannel)destChannel).transferFrom(sourceChannel, 0L, sourceChannel.size());
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (sourceChannel != null) {
                    sourceChannel.close();
                }
                if (destChannel != null) {
                    destChannel.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static int getFlag() {
        Scanner sc = null;
        File sdCard = Environment.getExternalStorageDirectory();
        File flag = new File(sdCard.getAbsolutePath() + "/trepn/GDflag");
        try {
            sc = new Scanner(flag);
        }
        catch (FileNotFoundException e) {
            return 0;
        }
        return sc.nextInt();
    }

    public static void traceMethod(String methodName) {
        if (TrepnLib.getFlag() <= 0) {
            File sdCard = Environment.getExternalStorageDirectory();
            File directory = new File(sdCard.getAbsolutePath() + "/trepn");
            File file = new File(directory, "TracedMethods.txt");
            FileOutputStream fOut = null;
            try {
                fOut = new FileOutputStream(file, true);
                OutputStreamWriter osw = new OutputStreamWriter(fOut);
                osw.write(methodName + "\n");
                osw.flush();
                osw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateState(Context ctx, int state, String description) {
        if (TrepnLib.getFlag() >= 0) {
            Context context = ctx != null ? ctx : (ctx = TrepnLib.context != null ? TrepnLib.context : TrepnLib.initContext());
            if (state == 0) {
                Intent stateUpdate = new Intent("com.quicinc.Trepn.UpdateAppState");
                int x = --globalState;
                stateUpdate.putExtra("com.quicinc.Trepn.UpdateAppState.Value", String.valueOf(x));
                stateUpdate.putExtra("com.quicinc.Trepn.UpdateAppState.Value.Desc", description);
                ctx.sendBroadcast(stateUpdate);
            } else {
                Intent stateUpdate = new Intent("com.quicinc.Trepn.UpdateAppState");
                int x = ++globalState;
                stateUpdate.putExtra("com.quicinc.Trepn.UpdateAppState.Value", String.valueOf(x));
                stateUpdate.putExtra("com.quicinc.Trepn.UpdateAppState.Value.Desc", description);
                ctx.sendBroadcast(stateUpdate);
            }
        }
    }

    public static void traceTest(String testName) {
        if (TrepnLib.getFlag() > 0) {
            File sdCard = Environment.getExternalStorageDirectory();
            File directory = new File(sdCard.getAbsolutePath() + "/trepn/TracedTests");
            File file = new File(directory, "TracedTests.txt");
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            FileOutputStream fOut = null;
            try {
                fOut = new FileOutputStream(file, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            OutputStreamWriter osw = new OutputStreamWriter(fOut);
            try {
                osw.write(testName + "\n");
                osw.flush();
                osw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static Application getApplicationUsingReflection() throws Exception {
        return (Application)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, (Object[])null);
    }

    static {
        globalState = 0;
        qtdTraces = 0;
        qtdMeasures = 0;
    }
}

